/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.message.IPAddress;
import apicore.mu.pdu.Header;
import apicore.ptmp.PtmpBuffer;

public class IpHeader
extends Header {
    public byte version = 0;
    public byte headerLen = 0;
    public byte tos = 0;
    public short length = 0;
    public short id = 0;
    public char flags = '\u0000';
    public short fragOffset = 0;
    public short ttl = 0;
    public short protocol = 0;
    public short checksum = 0;
    public int options = 0;
    public int padding = 0;
    public IPAddress src = null;
    public IPAddress dst = null;

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putByte(this.version);
        ptmpBuffer.putByte(this.headerLen);
        ptmpBuffer.putByte(this.tos);
        ptmpBuffer.putShort(this.length);
        ptmpBuffer.putShort(this.id);
        ptmpBuffer.putChar(this.flags);
        ptmpBuffer.putShort(this.fragOffset);
        ptmpBuffer.putShort(this.ttl);
        ptmpBuffer.putShort(this.protocol);
        ptmpBuffer.putShort(this.checksum);
        ptmpBuffer.putInt(this.options);
        ptmpBuffer.putInt(this.padding);
        ptmpBuffer.putIPAddress(this.src);
        ptmpBuffer.putIPAddress(this.dst);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.version = ptmpBuffer.getByte();
            this.headerLen = ptmpBuffer.getByte();
            this.tos = ptmpBuffer.getByte();
            this.length = ptmpBuffer.getShort();
            this.id = ptmpBuffer.getShort();
            this.flags = ptmpBuffer.getChar();
            this.fragOffset = ptmpBuffer.getShort();
            this.ttl = ptmpBuffer.getShort();
            this.protocol = ptmpBuffer.getShort();
            this.checksum = ptmpBuffer.getShort();
            this.options = ptmpBuffer.getInt();
            this.padding = ptmpBuffer.getInt();
            this.src = ptmpBuffer.getIPAddress();
            this.dst = ptmpBuffer.getIPAddress();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static IpHeader create(PtmpBuffer ptmpBuffer) {
        IpHeader ipHeader = new IpHeader();
        if (ipHeader.deserialize(ptmpBuffer)) {
            return ipHeader;
        }
        return null;
    }

    public String getTypeName() {
        return "CIpHeader";
    }

    public String toString() {
        String string = "";
        string = string + super.toString();
        string = string + "[IpHeader: ";
        string = string + "version=" + this.version + ", ";
        string = string + "headerLen=" + this.headerLen + ", ";
        string = string + "tos=" + this.tos + ", ";
        string = string + "length=" + this.length + ", ";
        string = string + "id=" + this.id + ", ";
        string = string + "flags=" + this.flags + ", ";
        string = string + "fragOffset=" + this.fragOffset + ", ";
        string = string + "ttl=" + this.ttl + ", ";
        string = string + "protocol=" + this.protocol + ", ";
        string = string + "checksum=" + this.checksum + ", ";
        string = string + "options=" + this.options + ", ";
        string = string + "padding=" + this.padding + ", ";
        string = string + "src=" + this.src + ", ";
        string = string + "dst=" + this.dst + "";
        string = string + "]";
        return string;
    }
}

